/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.donor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.notenoughanimations.donor.DonorSettings;
import dev.tr7zw.notenoughanimations.donor.ImageLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DonorSkinProvider {
    public static final Logger LOGGER = LogManager.getLogger();
    private static File settingsFile = new File("config", "tr7zwDonorSettings.json");
    private static DonorSettings settings;
    private static final String userAgent = "DonorSkin/1.0.0";
    private final UUID uuid;
    private ImageLoader.ImageFrame[] frames = null;
    private int length = 0;

    public DonorSkinProvider(UUID uuid) {
        this.uuid = uuid;
        if (!DonorSkinProvider.settings.enabled) {
            return;
        }
        this.prepare();
    }

    public class_2960 getSkin() {
        if (this.frames == null) {
            return null;
        }
        long targetFrame = System.currentTimeMillis() % (long)this.length;
        for (ImageLoader.ImageFrame frame : this.frames) {
            if ((targetFrame -= (long)(frame.getDelay() * 10)) > 0L) continue;
            return frame.getResource();
        }
        return null;
    }

    public class_1011 getNativeImage() {
        if (this.frames == null) {
            return null;
        }
        long targetFrame = System.currentTimeMillis() % (long)this.length;
        for (ImageLoader.ImageFrame frame : this.frames) {
            if ((targetFrame -= (long)(frame.getDelay() * 10)) > 0L) continue;
            return frame.getNativeImage();
        }
        return null;
    }

    private void prepare() {
        class_156.method_18349().execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        ImageLoader.ImageFrame[] tmpFrames;
                        URLConnection con = new URL("https://skins.trsha.re/" + DonorSkinProvider.this.uuid + ".gif").openConnection();
                        con.setRequestProperty("User-Agent", DonorSkinProvider.userAgent);
                        for (ImageLoader.ImageFrame frame : tmpFrames = ImageLoader.readGif(con.getInputStream())) {
                            DonorSkinProvider.this.length += frame.getDelay() * 10;
                        }
                        DonorSkinProvider.this.frames = tmpFrames;
                    }
                    catch (Exception e) {
                        if (e instanceof FileNotFoundException) break block3;
                        LOGGER.error("Error while loading the animated skin.", (Throwable)e);
                    }
                }
            }
        });
    }

    static {
        if (settingsFile.exists()) {
            try {
                settings = (DonorSettings)new Gson().fromJson((Reader)new FileReader(settingsFile), DonorSettings.class);
            }
            catch (Exception ex) {
                LOGGER.error("Error while loading " + settingsFile.getAbsolutePath() + ". Loading default values.", (Throwable)ex);
                settings = new DonorSettings();
            }
        } else {
            settings = new DonorSettings();
            try {
                Files.write(settingsFile.toPath(), new GsonBuilder().setPrettyPrinting().create().toJson((Object)settings).getBytes(), new OpenOption[0]);
            }
            catch (Exception ex) {
                LOGGER.error("Error while saving " + settingsFile.getAbsolutePath() + ".", (Throwable)ex);
            }
        }
        if (!DonorSkinProvider.settings.enabled) {
            LOGGER.info("Animated skins are disabled!");
        } else {
            LOGGER.info("Animated skins loaded and ready to use!");
        }
    }
}

